%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Lab10_Postal_Code.m  Dr. Bucks  07/8/2014
% Description: This script determines the zip code for a given Postal Bar
% Code
% Usage: Lab2A_Postal_Code; 
% when prompted, the Postal Bar Code is entered where a capital I
% represents a long dash and a . represents a short dash
% Example:
% Please enter the Postal Bar Code: II.I...I.I.II......II.I..I.I.I....II.I..I..II.I..I.I
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% clean house
clear all;
close all;
clc;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ask user for zip code
code = input('Please enter the Postal Bar Code: ','s');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% break the zip code into segments of 5 and convert to the appropriate
% number
zip = '';                                   % empty initial zip code
digit_code = '';                            % empty initial digit
for k = 1:length(code)                      % go through all valid bars
    digit_code = [digit_code code(k)];      % get next digit
    if length(digit_code) == 5              % if 5 bars collected
        switch digit_code                   % determine number from barcode
            case '...II'
                number = '1';
            case '..I.I'
                number = '2';
            case '..II.'
                number = '3';
            case '.I..I'
                number = '4';
            case '.I.I.'
                number = '5';
            case '.II..'
                number = '6';
            case 'I...I'
                number = '7';
            case 'I..I.'
                number = '8';
            case 'I.I..'
                number = '9';
            otherwise
                number = '0';
        end
        if count <= 8                           % if value is a part of the zip code
            zip = [zip number];                 % add digit to 
            count = count + 1;                  % update count
            digit_code = '';                    % reset digit
        else                                    % if value is the error check value
            error_val = number;                 % store error check value
        end
        if count == 5
            zip = [zip '-'];                % add dash after 5 digits
        end
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% check for errors in reading bar code
% sum zip digits
zip_sum = 0;                                            % initialize sum
for k = 1:10
    if k ~= 6
        zip_sum = zip_sum + str2num(zip(k));            % add each digit
    end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% check for error
if mod(error_val+zip_sum,10) ~= 0
    fprintf('There is an error in the Postal Bar Code.  Zip code cannot be determined.\n');
else
    fprintf('The zip code is %i.\n',zip);
end